<?php

namespace App\Helpers;

use App\GeneralSetting;

class AppHelper
{
    // get app general setting
    public function getGeneralSettigns()
    {
        $settings = [
            'compnayName' => GeneralSetting::where('key', 'company_name')->firstOrFail()->value,
            'compnayTagline' => GeneralSetting::where('key', 'compnay_tagline')->firstOrFail()->value,
            'email' => GeneralSetting::where('key', 'email_address')->firstOrFail()->value,
            'phone' => GeneralSetting::where('key', 'phone_number')->firstOrFail()->value,
            'address' => GeneralSetting::where('key', 'address')->firstOrFail()->value,
            'currencyName' => GeneralSetting::where('key', 'currency_name')->firstOrFail()->value,
            'currencySymbol' => GeneralSetting::where('key', 'currency_symbol')->firstOrFail()->value,
            'currencyPosition' => GeneralSetting::where('key', 'currency_position')->firstOrFail()->value,
            'timezone' => GeneralSetting::where('key', 'timezone')->firstOrFail()->value,
            'codePefix' => GeneralSetting::where('key', 'purchase_code_prefix')->firstOrFail()->value,

            'processingCodePefix' => GeneralSetting::where('key', 'processing_code_prefix')->firstOrFail()->value,

            'finishedCodePefix' => GeneralSetting::where('key', 'finished_code_prefix')->firstOrFail()->value,

            'transferredCodePrefix' => GeneralSetting::where('key', 'transferred_code_prefix')->firstOrFail()->value,


            'startingCode' => GeneralSetting::where('key', 'starting_purchase_code')->firstOrFail()->value,
            'logo' => asset('img') . '/' . GeneralSetting::where('key', 'logo')->firstOrFail()->value,
            'smallLogo' => asset('img') . '/' . GeneralSetting::where('key', 'small_logo')->firstOrFail()->value,
            'favicon' =>  asset('/') . GeneralSetting::where('key', 'favicon')->firstOrFail()->value,
            'copyright' =>  GeneralSetting::where('key', 'copyright')->firstOrFail()->value ?? '',
        ];
        $settings = (object) $settings;
        return $settings;
    }

    // return formatted currency
    public function formattedCurrency($amount)
    {
        if ($this->getGeneralSettigns()->currencyPosition == 'left') {
            return $amount > 0 ? $this->getGeneralSettigns()->currencySymbol . $amount : $this->getGeneralSettigns()->currencySymbol . "0";
        } else {
            return $amount > 0 ? $amount . $this->getGeneralSettigns()->currencySymbol : "0" . $this->getGeneralSettigns()->currencySymbol;
        }
    }

    // return discount amount
    public function discountAmount($discount, $subtotal)
    {
        return ($discount / 100) * $subtotal;
    }

    // return purchase code
    public function pruchaseCode($code)
    {
        return $this->getGeneralSettigns()->codePefix . $code;
    }

    // return processing code
    public function processingCode($code)
    {
        return $this->getGeneralSettigns()->processingCodePefix . $code;
    }

    // return finished code
    public function finishedCode($code)
    {
        return $this->getGeneralSettigns()->finishedCodePefix . $code;
    }

    // return transferred code
    public function transferredCode($code)
    {
        return $this->getGeneralSettigns()->transferredCodePrefix . $code;
    }

    public function startQueryLog()
    {
        \DB::enableQueryLog();
    }

    public function showQueries()
    {
        dd(\DB::getQueryLog());
    }

    public static function instance()
    {
        return new AppHelper();
    }
}
