<?php

namespace App;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Showroom extends Model
{
    use Sluggable;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'slug', 'code', 'manager', 'email', 'phone_number', 'address', 'note', 'status'
    ];

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }

    /**
     * Return relation with TransferredProduct Model
     *
     *
     */
    public function transferredProduct()
    {
        return $this->hasMany('App\TransferredProduct');
    }

    /**
     * Return true if the showroom is active
     *
     * @return boolean
     */
    public function isActive()
    {
        return $this->status == 1 ? true : false;
    }

    /**
     * Return showroom short note
     *
     * @return string
     */
    public function shortNote()
    {
        if(strlen($this->note) > 80)
        {
            return substr($this->note, 0, 80).'...';
        }
        return $this->note;
    }
}
