<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\GeneralSetting;

class CreateGeneralSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('general_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key');
            $table->string('display_name')->nullable();
            $table->text('value')->nullable();
            $table->timestamps();
        });

        // seed basic data to table
        $settingElemetns = [
            'company_name' => 'Productify',
            'compnay_tagline' => 'Production Management System',
            'email_address' => 'support@codeshape.net',
            'phone_number' => '0170000000',
            'address' => 'Mirpur-10, Dhaka-1216, Bangladesh',
            'currency_name' => 'USD',
            'currency_symbol' => '$',
            'currency_position' => 'left',
            'timezone' => 'America/New_York',
            'purchase_code_prefix' => 'PUR-',
            'processing_code_prefix' => 'PRO-',
            'finished_code_prefix' => 'FIN-',
            'transferred_code_prefix' => 'TRA-',
            'starting_purchase_code' => '1',
            'logo' => 'logo-main.svg',
            'small_logo' => 'small_logo.png',
            'favicon' => 'favicon.ico',
            'copyright' => 'Copyright © 2020 Productify All rights reserved'
        ];
        foreach ($settingElemetns as $key => $value) {
            GeneralSetting::create([
                'key' => $key,
                'display_name' => ucwords(str_replace("_", " ", $key)),
                'value' => $value
            ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('general_settings');
    }
}
