@php
    use \App\Helpers\AppHelper;
@endphp

@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Finished Products') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="#">{{ __('Products') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Finished Products') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($products->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All finished products') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('finished.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add Finished') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->

                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Processing Code') }}</th>
                                    <th>{{ __('Finished Code') }}</th>
                                    <th>{{ __('Product Type') }}</th>
                                    <th>{{ __('Sizes') }}</th>
                                    <th>{{ __('Quantities') }}</th>
                                    <th>{{ __('Finished Date') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th class="text-right">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                    @foreach ($products as $key => $product)
                                    <tr>
                                        <td>{{ ++$key  }}</td>
                                        <td>
                                            {{ AppHelper::instance()->processingCode($product->processingProduct->processing_code) }}
                                        </td>
                                        <td>{{ AppHelper::instance()->finishedCode($product->finished_code) }}</td>
                                        <td>{{ $product->productType->name }} </td>
                                        <td>{{ $product->sizes }} </td>
                                        <td>{{ $product->quantities }} </td>
                                        <td>{{ date_format(date_create($product->finished_date), 'd-M-Y') }}</td>
                                        <td>
                                            @if($product->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle action-dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    @if($product->isActive())
                                                        <a href="{{ route('finished.status', $product->slug)  }}" class="dropdown-item"><i class="fas fa-window-close"></i> {{ __('Inactive') }}</a>
                                                    @else
                                                        <a href="{{ route('finished.status', $product->slug)  }}" class="dropdown-item"><i class="fas fa-check-square"></i> {{ __('Active') }}</a>
                                                    @endif
                                                    <a href="{{ route('finished.show', $product->slug) }}" class="dropdown-item"><i class="fas fa-eye"></i> {{ __('View') }}</a>
                                                    <a href="{{ route('finished.edit', $product->slug) }}" class="dropdown-item"><i class="fas fa-edit"></i> {{ __('Edit') }}</a>
                                                    <a href="{{ route('finished.delete', $product->slug) }}" class="dropdown-item delete-btn" data-msg="{{ __('Are you sure you want to delete this finished product?') }}"><i class="fas fa-trash"></i> {{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    @if($products->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $products->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no finished product found in the database. Create your very first finished product.') }}</p>
                        <a href="{{ route('finished.create') }}" class="btn btn-primary">
                            {{ __('Add Finished Product') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection

