@php
    use \App\Helpers\AppHelper;
@endphp

@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Processing Products') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="#">{{ __('Products') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Processing Products') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($processingProducts->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All processing products') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('processing.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add Processing Product') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Purchased Code') }}</th>
                                    <th>{{ __('Processing Code') }}</th>
                                    @if(count($steps) <= 6)
                                        @foreach ($steps as $step)
                                        <th>{{ $step->step_name }}</th>
                                        @endforeach
                                    @endif
                                    <th>{{ __('Start Date') }}</th>
                                    <th>{{ __('End Date') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th class="text-right">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($processingProducts as $key => $product)
                                    <tr>
                                        <td>{{ ++$key  }}</td>
                                        <td>{{ AppHelper::instance()->pruchaseCode($product->purchase->purchase_code) }}</td>
                                        <td>{{ AppHelper::instance()->processingCode($product->processing_code) }}</td>

                                        @if(count($steps) <= 6)
                                            @foreach ($steps as $step)
                                                <td>
                                                    @foreach ($product->selectedStaff()->where('processing_step_id', $step->step_id)->get() as $staff)
                                                        {{ $staff->name }},
                                                    @endforeach
                                                </td>
                                            @endforeach
                                        @endif
                                        <td>{{ date_format(date_create($product->start_date), 'd-M-Y') }}</td>
                                        <td>{{ date_format(date_create($product->end_date), 'd-M-Y') }}</td>
                                        <td>
                                            @if($product->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td class="text-right">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle action-dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    @if($product->isActive())
                                                        <a href="{{ route('processing.status', $product->slug)  }}" class="dropdown-item"><i class="fas fa-window-close"></i> {{ __('Inactive') }}</a>
                                                    @else
                                                        <a href="{{ route('processing.status', $product->slug)  }}" class="dropdown-item"><i class="fas fa-check-square"></i> {{ __('Active') }}</a>
                                                    @endif
                                                    <a href="{{ route('processing.show', $product->slug) }}" class="dropdown-item"><i class="fas fa-eye"></i> {{ __('View') }}</a>
                                                    <a href="{{ route('processing.edit', $product->slug) }}" class="dropdown-item"><i class="fas fa-edit"></i> {{ __('Edit') }}</a>
                                                    <a href="{{ route('processing.delete', $product->slug) }}" class="dropdown-item delete-btn" data-msg="{{ __('Are you sure you want to delete this processing product?') }}"><i class="fas fa-trash"></i> {{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    @if($processingProducts->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $processingProducts->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no processing product found in the database. Create your very first processing product.') }}</p>
                        <a href="{{ route('processing.create') }}" class="btn btn-primary">
                            {{ __('Add Processing Product') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection
