@php
    use \App\Helpers\AppHelper;
@endphp

@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Purchase Inventory') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="#">{{ __('Products') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Purchase Inventory') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($products->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All purchase products') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('purchases.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add Purchase') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Product') }}</th>
                                    <th>{{ __('Purchased Qty') }}</th>
                                    <th>{{ __('Used Qty') }}</th>
                                    <th>{{ __('Return Qty') }}</th>
                                    <th>{{ __('Damage Qty') }}</th>
                                    <th>{{ __('Available Qty') }}</th>
                                    <th>{{ __('Unit Price') }}</th>
                                    <th class="text-right">{{ __('Purchase') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($products as $key => $product)
                                    @php
                                        $returnQty = $product->return_quantity > 0 ? $product->return_quantity  : 0;
                                        $damageQty =  $product->damage_quantity > 0 ? $product->damage_quantity : 0;
                                    @endphp
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>{{ $product->product_name }}</td>
                                        <td>{{ $product->quantity }} {{ $product->unit }}</td>
                                        <td>{{ $product->usedQty() }} {{ $product->unit }}</td>
                                        <td>{{ $returnQty }} {{ $product->unit }}</td>
                                        <td>{{ $damageQty }} {{ $product->unit }}</td>
                                        <td>{{ $product->availableQuantity() }} {{ $product->unit }}</td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($product->unit_price) }}</td>
                                        <td class="text-right">{{ AppHelper::instance()->pruchaseCode($product->purchase->purchase_code) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    @if($products->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $products->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no purchase found in the database. Create your very first purchase.') }}</p>
                        <a href="{{ route('purchases.create') }}" class="btn btn-primary">
                            {{ __('Add Purchase') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection

