@php
    use \App\Helpers\AppHelper;
@endphp

@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Purchases') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="#">{{ __('Products') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Purchases') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($purchases->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All purchases') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('purchases.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add Purchase') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Purchase Code') }}</th>
                                    <th>{{ __('Date') }}</th>
                                    <th>{{ __('Supplier') }}</th>
                                    <th>{{ __('Subtotal') }}</th>
                                    <th>{{ __('Discount') }}</th>
                                    <th>{{ __('Trasnport') }}</th>
                                    <th>{{ __('Total') }}</th>
                                    <th>{{ __('Paid') }}</th>
                                    <th>{{ __('Due') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($purchases as $key => $purchase)
                                    <tr>
                                        <td>{{ ++$key  }}</td>
                                        <td>{{ AppHelper::instance()->pruchaseCode($purchase->purchase_code) }}</td>
                                        <td>
                                            {{ \Carbon\Carbon::parse($purchase->purchase_date)->format('d-M-Y') }}
                                        </td>
                                        <td>{{ ucfirst($purchase->supplier->name)  }} </td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->sub_total) }} </td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->discount) }}</td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->trasnport) }}</td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->total) }}</td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->total_paid) }}</td>
                                        <td>{{ AppHelper::instance()->formattedCurrency($purchase->total_due) }}</td>
                                        <td>
                                            @if($purchase->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle action-dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    @if($purchase->isActive())
                                                        <a href="{{ route('purchases.status', $purchase->purchase_code)  }}" class="dropdown-item"><i class="fas fa-window-close"></i> {{ __('Inactive') }}</a>
                                                    @else
                                                        <a href="{{ route('purchases.status', $purchase->purchase_code)  }}" class="dropdown-item"><i class="fas fa-check-square"></i> {{ __('Active') }}</a>
                                                    @endif
                                                    <a href="{{ route('purchases.invoice', $purchase->purchase_code) }}" class="dropdown-item"><i class="fas fa-file-alt"></i> {{ __('Invoice') }}</a>
                                                    <a href="{{ route('purchases.show', $purchase->purchase_code) }}" class="dropdown-item"><i class="fas fa-eye"></i> {{ __('View') }}</a>
                                                    <a href="{{ route('purchases.edit', $purchase->purchase_code) }}" class="dropdown-item"><i class="fas fa-edit"></i> {{ __('Edit') }}</a>
                                                    <a href="{{ route('purchases.delete', $purchase->purchase_code) }}" class="dropdown-item delete-btn" data-msg="{{ __('Are you sure you want to delete this purchase?') }}"><i class="fas fa-trash"></i> {{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                    @if($purchases->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $purchases->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no purchase found in the database. Create your very first purchase.') }}</p>
                        <a href="{{ route('purchases.create') }}" class="btn btn-primary">
                            {{ __('Add Purchase') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection

