@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Showrooms') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.setup') }}">{{ __('Setup') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Showrooms') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($showrooms->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All showrooms') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('showrooms.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add Showroom') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Code') }}</th>
                                    <th>{{ __('Manager') }}</th>
                                    <th>{{ __('Phone') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Created') }}</th>
                                    <th class="text-right">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($showrooms as $key => $showroom)
                                    <tr>
                                        <td>{{ ++$key  }}</td>
                                        <td>{{ $showroom->name }} </td>
                                        <td>{{ $showroom->code }} </td>
                                        <td>{{ ucfirst($showroom->manager) }} </td>
                                        <td>{{ $showroom->phone_number }} </td>
                                        <td>
                                            @if($showroom->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($showroom->created_at)->format('d-M-Y') }}</td>
                                        <td class="text-right">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle action-dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    @if($showroom->isActive())
                                                        <a href="{{ route('showrooms.status', $showroom->slug)  }}" class="dropdown-item"><i class="fas fa-window-close"></i> {{ __('Inactive') }}</a>
                                                    @else
                                                        <a href="{{ route('showrooms.status', $showroom->slug)  }}" class="dropdown-item"><i class="fas fa-check-square"></i> {{ __('Active') }}</a>
                                                    @endif
                                                    <a href="{{ route('showrooms.show', $showroom->slug) }}" class="dropdown-item"><i class="fas fa-eye"></i> {{ __('View') }}</a>
                                                    <a href="{{ route('showrooms.edit', $showroom->slug) }}" class="dropdown-item"><i class="fas fa-edit"></i> {{ __('Edit') }}</a>
                                                    <a href="{{ route('showrooms.delete', $showroom->slug)  }}" class="dropdown-item delete-btn" data-msg="{{ __('Are you sure you want to delete this showroom?') }}"><i class="fas fa-trash"></i> {{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->

                    @if($showrooms->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $showrooms->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no showroom found in the database. Create your very first showroom.') }}</p>
                        <a href="{{ route('showrooms.create') }}" class="btn btn-primary">
                            {{ __('Add Showroom') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection
