@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('View Supplier') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ route('suppliers.index') }}">{{ __('Suppliers') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('View supplier') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        <div class="row">
            <div class="card col-md-12">
                <div class="card-header">
                    <h3 class="card-title">{{ __('View supplier') }}: {{ $supplier->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('suppliers.index') }}" class="btn btn-block btn-primary">
                            <i class="fas fa-long-arrow-alt-left"></i> {{ __('Go Back') }}
                        </a>
                    </div>
                </div>
                <!-- /.card-header -->
                <div class="card-body p-0">
                    <div class="row">
                        <div class="col-md-12 col-lg-4 text-center justify-content-center align-self-center">
                            @if(!empty($supplier->profile_picture))
                                <img src="{{ $supplier->profilePic() }}" class="img-fluid">
                            @else
                                <div class="show-no-preview"></div>
                            @endif
                        </div>
                        <div class="col-md-12 col-lg-8 table-responsive view-table">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td><strong>{{ __('Name') }}:</strong> {{ $supplier->name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Email') }}:</strong> {{ $supplier->email }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Phone') }}:</strong> {{ $supplier->phone_number }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Company Name') }}:</strong> {{ $supplier->company_name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Designation') }}:</strong> {{ $supplier->designation }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>{{ __('Address') }}:</strong> {{ $supplier->address }}</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <strong>{{ __('Status') }}:</strong>
                                            @if($supplier->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /.content -->
@endsection
