@extends('layouts.admin')

@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">{{ __('Users') }}</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item">
                        <a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a>
                    </li>
                    <li class="breadcrumb-item active">{{ __('Users') }}</li>
                </ol>
            </div>
        </div>
    </div>
</div>
<!-- /.content-header -->

<!-- Main content -->
<div class="content">
    <div class="container">
        @if($users->total() > 0)
            <div class="row">
                @include('admin.includes.alert')
                <div class="card col-md-12">
                    <div class="card-header">
                        <h3 class="card-title">{{ __('All users') }}</h3>
                        <div class="card-tools">
                            <a href="{{ route('users.create') }}" class="btn btn-block btn-primary">
                                {{ __('Add User') }} <i class="fas fa-plus-circle"></i>
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body p-0 table-responsive min-height-150">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('Picture') }}</th>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Type') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Created') }}</th>
                                    <th class="text-right">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($users as $key => $user)
                                    <tr>
                                        <td>{{ ++$key  }}</td>
                                        <td>
                                            @if(!empty($user->profile_picture))
                                                <img src="{{ $user->profilePic() }}" class="table-image-preview">
                                            @else
                                                <div class="no-preview"></div>
                                            @endif
                                        </td>
                                        <td>{{ $user->name }} </td>
                                        <td>{{ $user->email }} </td>
                                        <td>
                                            @if($user->isAdmin())
                                                <span class="badge badge-success"><i class="fas fa-user-secret"></i> {{ __('Admin User') }}</span>
                                            @else
                                                <span class="badge badge-primary"><i class="fas fa-user-tie"></i> {{ __('Genereal User') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($user->isActive())
                                                <span class="badge badge-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge badge-warning">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($user->created_at)->format('d-M-Y') }}</td>
                                        <td class="text-right">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary dropdown-toggle action-dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fas fa-ellipsis-v"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-right">
                                                    @if($user->isActive())
                                                        <a href="{{ route('users.status', $user->id)  }}" class="dropdown-item"><i class="fas fa-window-close"></i> {{ __('Inactive') }}</a>
                                                    @else
                                                        <a href="{{ route('users.status', $user->id)  }}" class="dropdown-item"><i class="fas fa-check-square"></i> {{ __('Active') }}</a>
                                                    @endif
                                                    <a href="{{ route('users.edit', $user->id) }}" class="dropdown-item"><i class="fas fa-edit"></i> {{ __('Edit') }}</a>
                                                    @if($user->id != auth()->user()->id)
                                                        <a href="{{ route('users.delete', $user->id) }}" class="dropdown-item delete-btn" data-msg="{{ __('Are you sure you want to delete this user?') }}"><i class="fas fa-trash"></i> {{ __('Delete') }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->

                    @if($users->total() > 15)
                        <div class="card-footer clearfix">
                            <div class="float-right">
                                {{ $users->links() }}
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="row">
                <div class="info-box col-md-12">
                    <span class="info-box-icon bg-primary">
                        <i class="fas fa-box-open"></i>
                    </span>
                    <div class="info-box-content ml-30">
                        <p>{{ __('Sorry, no user found in the database. Create your very first user.') }}</p>
                        <a href="{{ route('users.create') }}" class="btn btn-primary">
                            {{ __('Add User') }} <i class="fas fa-plus-circle"></i>
                        </a>
                    </div>
                    <!-- /.info-box-content -->
                </div>
            </div>
        @endif
    </div>
</div>
<!-- /.content -->
@endsection
