<?php $__env->startSection('content'); ?>

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo e(__('Dashboard')); ?></h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item active"><?php echo e(__('Dashboard')); ?></li>
                </ol>
            </div>
        </div>
    </div>
</div>



<div class="content">
    <div class="container-fluid">
        <?php if($stats->staff > 0 && $stats->suppliers > 0 && $stats->categories > 0 && $stats->subCats > 0 && $stats->purchases > 0): ?>
            <div class="row">
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('categories.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-tags"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Product Categories')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->categories); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('staff.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-users"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Staff')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->staff); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('suppliers.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-people-carry"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Suppliers')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->suppliers); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('expenses.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-wallet"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Expenses')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->expenses); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('purchases.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-shopping-basket"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Purchases')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->purchases); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('processing.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-tools"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Processing Products')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->processing); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('finished.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-th-list"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Finished Products')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->finished); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="col-12 col-sm-6 col-md-3 stats">
                    <a href="<?php echo e(route('transferred.index')); ?>">
                        <div class="info-box">
                            <span class="info-box-icon bg-success elevation-1"><i class="fas fa-random"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo e(__('Transferred Products')); ?></span>
                                <span class="info-box-number"><?php echo e($stats->transferred); ?></span>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        <?php else: ?>
            <div class="row">
                <div class="todo-box col-md-12">
                    <div class="card ">
                        <div class="card-header ui-sortable-handle">
                            <h3 class="card-title">
                                <i class="ion ion-clipboard mr-1"></i>
                                <?php echo e(__('To Do List')); ?>

                            </h3>
                        </div>
                        <div class="card-body">
                            <ul class="todo-list ui-sortable">
                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="setup" name="setup" <?php if(\App\Size::count() > 0 && \App\PaymentMethod::count() > 0 && \App\Unit::count() > 0 && \App\ProcessingStep::count() > 0 && \App\Showroom::count() > 0): ?> checked <?php endif; ?>>

                                        <label class="custom-control-label todo-label" for="setup">
                                            <?php if(\App\Size::count() > 0 && \App\PaymentMethod::count() > 0 && \App\Unit::count() > 0 && \App\ProcessingStep::count() > 0 && \App\Showroom::count() > 0): ?>
                                                <del><?php echo e(__('You haven\'t customized the setup page yet. Setup your application and create some sizes, units, etc.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t customized the setup page yet. Setup your application and create some sizes, units, etc.')); ?>

                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('admin.setup')); ?>" class="btn btn-success">
                                            <?php echo e(__('Setup')); ?>

                                            <i class="fas fa-paper-plane"></i>
                                        </a>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="category" name="category" <?php echo e($stats->categories > 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label todo-label" for="category">
                                            <?php if($stats->categories > 0): ?>
                                                <del><?php echo e(__('You haven\'t created a category yet. Create a new category.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t created a category yet. Create a new category.')); ?>

                                            <?php endif; ?>

                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('categories.create')); ?>" class="btn btn-success">

                                            <?php if($stats->categories > 0): ?>
                                                <?php echo e(__('Add Another')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Add New')); ?>

                                            <?php endif; ?>
                                            <i class="fas fa-plus-circle"></i>
                                        </a>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="subCategory" name="subCategory" <?php echo e($stats->subCats > 0 ? 'checked' :  ''); ?>>
                                        <label class="custom-control-label todo-label" for="subCategory">
                                            <?php if($stats->subCats > 0): ?>
                                                <del><?php echo e(__('You haven\'t created a sub category yet. Create a new sub category.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t created a sub category yet. Create a new sub category.')); ?>

                                            <?php endif; ?>

                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('subCategories.create')); ?>" class="btn btn-success">

                                            <?php if($stats->subCats > 0): ?>
                                                <?php echo e(__('Add Anohter')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Add New')); ?>

                                            <?php endif; ?>
                                            <i class="fas fa-plus-circle"></i>
                                        </a>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="staff" name="staff" <?php echo e($stats->staff > 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label todo-label" for="staff">
                                            <?php if($stats->staff > 0): ?>
                                                <del><?php echo e(__('You haven\'t created a staff yet. Create a new staff.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t created a staff yet. Create a new staff.')); ?>

                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('staff.create')); ?>" class="btn btn-success">
                                            <?php if($stats->staff > 0): ?>
                                                <?php echo e(__('Add Another')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Add New')); ?>

                                            <?php endif; ?>
                                            <i class="fas fa-plus-circle"></i>
                                        </a>
                                    </div>
                                </li>
                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="supplier" name="supplier" <?php echo e($stats->suppliers > 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label todo-label" for="supplier">
                                            <?php if($stats->suppliers > 0): ?>
                                                <del><?php echo e(__('You haven\'t created a supplier yet. Create a new supplier.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t created a supplier yet. Create a new supplier.')); ?>

                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('suppliers.create')); ?>" class="btn btn-success">
                                            <?php if($stats->suppliers > 0): ?>
                                                <?php echo e(__('Add Another')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Add New')); ?>

                                            <?php endif; ?>
                                            <i class="fas fa-plus-circle"></i>
                                        </a>
                                    </div>
                                </li>

                                <li>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="purchase" name="purchase" <?php echo e($stats->purchases > 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label todo-label" for="purchase">
                                            <?php if($stats->purchases > 0): ?>
                                                <del><?php echo e(__('You haven\'t created a purchase yet. Create a new purchase.')); ?></del>
                                            <?php else: ?>
                                                <?php echo e(__('You haven\'t created a purchase yet. Create a new purchase.')); ?>

                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <div class="text-right todo-btn xs-text-left">
                                        <a href="<?php echo e(route('purchases.create')); ?>" class="btn btn-success">

                                            <?php if($stats->purchases > 0): ?>
                                                <?php echo e(__('Add Another')); ?>

                                            <?php else: ?>
                                                <?php echo e(__('Add New')); ?>

                                            <?php endif; ?>
                                            <i class="fas fa-plus-circle"></i>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-md-12 col-lg-6">
                <div class="card card-success w-100">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Purcahses in last 12 months')); ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo $purchasesChart->container(); ?>

                    </div>
                    <!-- /.card-body -->
                </div>
            </div>
            <div class="col-md-12 col-lg-6">
                <div class="card card-success w-100">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Expenses in last 12 months')); ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo $expenseChart->container(); ?>

                    </div>
                </div>
            </div>
            <div class="col-md-12 col-lg-6">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Finished quantities in last 12 months')); ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo $finishedQtyChart->container(); ?>

                    </div>
                </div>
            </div>
            <div class="col-md-12 col-lg-6">
                <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title"><?php echo e(__('Transferred quantities in last 12 months')); ?></h3>
                    </div>
                    <div class="card-body">
                        <?php echo $transferredQtyChart->container(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-script'); ?>
    
    <script src="<?php echo e(asset('js/Chart.min.js')); ?>" charset=utf-8></script>
    <?php if($purchasesChart): ?>
        <?php echo $purchasesChart->script(); ?>

    <?php endif; ?>

    <?php if($finishedQtyChart): ?>
        <?php echo $finishedQtyChart->script(); ?>

    <?php endif; ?>

    <?php if($transferredQtyChart): ?>
        <?php echo $transferredQtyChart->script(); ?>

    <?php endif; ?>

    <?php if($expenseChart): ?>
        <?php echo $expenseChart->script(); ?>

    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\productify\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>