<?php
    use \App\Helpers\AppHelper;
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="description" content="<?php echo e(__('Productify is a production management system build to simplify production or manufacturing process. Productify is lightweight, secure and fast and based on laravel.')); ?>">
        <meta name="keywords" content="<?php echo e(__('Productify, Production management system, Manufacturing system, Inventory system, Stock management, Workshop management, Row material management, Garments System, Food and Beverage, Furniture Companies')); ?>">
        <meta name="author" content="<?php echo e(__('Codeshaper')); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <!-- CSRF Token -->
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <!-- Title -->
        <title><?php echo e(AppHelper::instance()->getGeneralSettigns()->compnayTagline); ?></title>
        <!-- favicon -->
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(AppHelper::instance()->getGeneralSettigns()->favicon); ?>">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(AppHelper::instance()->getGeneralSettigns()->favicon); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(AppHelper::instance()->getGeneralSettigns()->favicon); ?>">
        <link rel="manifest" href="<?php echo e(asset('/site.webmanifest')); ?>">
        <!-- Google font -->
        <link href="https://fonts.googleapis.com/css?family=Sen:400,700,800&display=swap" rel="stylesheet">
        <!-- Main css -->
        <link rel="stylesheet" type="text/css" href=" <?php echo e(asset('css/app.css')); ?> ">
        <!-- Admin panel css -->
        <link rel="stylesheet" type="text/css" href=" <?php echo e(asset('css/main.css')); ?> ">
        <?php echo $__env->yieldContent('extra-style'); ?>
    </head>
    <body class="hold-transition sidebar-mini">
        <div class="wrapper" id="app">
            <!-- Navbar -->
            <?php echo $__env->make('admin.components.top_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.navbar -->

            <!-- Main Sidebar Container -->
            <?php echo $__env->make('admin.components.side_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /.Main Sidebar Container -->

            <!-- page content -->
            <div class="content-wrapper">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <!-- /.page content-->

            <!-- Main Footer -->
            <?php echo $__env->make('admin.components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--/. Main Footer -->
        </div>
        <!-- ./wrapper -->

        <!-- REQUIRED SCRIPTS -->
        <script src="<?php echo e(asset('js/app.js')); ?> "></script>
        <script src="<?php echo e(asset('js/main.js')); ?> "></script>
        <?php echo $__env->yieldContent('extra-script'); ?>

    </body>
</html>
<?php /**PATH C:\laragon\www\productify\resources\views/layouts/admin.blade.php ENDPATH**/ ?>