<?php
    use \App\Helpers\AppHelper;
?>

<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('dashboard')); ?>" class="brand-link">
        <!-- Large Device  -->
        <img class="lg-logo" src="<?php echo e(AppHelper::instance()->getGeneralSettigns()->logo); ?>" alt="<?php echo e(AppHelper::instance()->getGeneralSettigns()->compnayName); ?>">
        <!-- Small Device -->
        <img class="sm-logo" src="<?php echo e(AppHelper::instance()->getGeneralSettigns()->smallLogo); ?>" alt="<?php echo e(AppHelper::instance()->getGeneralSettigns()->compnayName); ?>">
    </a>
    <!-- Sidebar -->
    <div class="sidebar custom-sidebar">
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <li class="nav-header text-bold"><?php echo e(__('ACTIVITY')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link  <?php echo e((request()->is('admin/dashboard')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-home"></i>
                        <p><?php echo e(__('Dashboard')); ?></p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href=" <?php echo e(route('staff.index')); ?> " class="nav-link <?php echo e((request()->is('admin/staff*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-users"></i>
                        <p><?php echo e(__('Staff')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\Staff::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('suppliers.index')); ?>" class="nav-link <?php echo e((request()->is('admin/suppliers*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-people-carry"></i>
                        <p><?php echo e(__('Suppliers')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\Supplier::count()); ?></span>
                    </a>
                </li>
                <?php if(auth()->user()->isAdmin()): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(route('users.index')); ?>" class="nav-link <?php echo e((request()->is('admin/users*')) ? 'active' : ''); ?>">
                            <i class="nav-icon fas fa-users-cog"></i>
                            <p><?php echo e(__('Users')); ?></p>
                            <span class="right badge badge-success"><?php echo e(\App\User::count()); ?></span>
                        </a>
                    </li>
                <?php endif; ?>
                <li class="nav-header text-bold"><?php echo e(__('EXPENSE')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('expCategories.index')); ?>" class="nav-link <?php echo e((request()->is('admin/expense-categories*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-list-alt"></i>
                        <p><?php echo e(__('Categories')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\ExpenseCategory::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('expenses.index')); ?>" class="nav-link <?php echo e((request()->is('admin/expenses*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-wallet"></i>
                        <p><?php echo e(__('Expenses')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\Expense::count()); ?></span>
                    </a>
                </li>

                <li class="nav-header text-bold"><?php echo e(__('PURCHASE')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('purchases.index')); ?>" class="nav-link <?php echo e((request()->is('admin/purchases*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-shopping-basket"></i>
                        <p><?php echo e(__('Purchases')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\Purchase::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('purchaseReturn.index')); ?>" class="nav-link <?php echo e((request()->is('admin/return-purchases*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-undo-alt"></i>
                        <p><?php echo e(__('Return Purchases')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\PurchaseReturn::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('purchaseDamage.index')); ?>" class="nav-link <?php echo e((request()->is('admin/damage-purchases*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-trash-alt"></i>
                        <p><?php echo e(__('Damage Purchases')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\PurchaseDamage::count()); ?></span>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('purchaseInventory.index')); ?>" class="nav-link <?php echo e((request()->is('admin/purchase-inventory*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-boxes"></i>
                        <p><?php echo e(__('Purchase Inventory')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\PurchaseProduct::count()); ?></span>
                    </a>
                </li>

                <li class="nav-header text-bold"><?php echo e(__('PRODUCT')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('categories.index')); ?>" class="nav-link <?php echo e((request()->is('admin/categories*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tags"></i>
                        <p><?php echo e(__('Categories')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\Category::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('subCategories.index')); ?>" class="nav-link <?php echo e((request()->is('admin/sub-categories*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-code-branch"></i>
                        <p><?php echo e(__('Sub Categories')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\SubCategory::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('processing.index')); ?>" class="nav-link <?php echo e((request()->is('admin/processing-products*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tools"></i>
                        <p><?php echo e(__('Processing')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\ProcessingProduct::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('finished.index')); ?>" class="nav-link <?php echo e((request()->is('admin/finished-products*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-th-list"></i>
                        <p><?php echo e(__('Finished')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\FinishedProduct::count()); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(route('transferred.index')); ?>" class="nav-link <?php echo e((request()->is('admin/transferred-products*')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-random"></i>
                        <p><?php echo e(__('Transferred')); ?></p>
                        <span class="right badge badge-success"><?php echo e(\App\TransferredProduct::count()); ?></span>
                    </a>
                </li>
                


                <li class="nav-header text-bold"><?php echo e(__('REPORT')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('purchase.report')); ?>" class="nav-link <?php echo e((request()->is('admin/purchase-report')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-area"></i>
                        <p><?php echo e(__('Purchase')); ?></p>
                    </a>
                </li>
                <li class="nav-item has-treeview <?php echo e((request()->is('admin/processing-report')) ? 'menu-open' : ''); ?> <?php echo e((request()->is('admin/finished-report')) ? 'menu-open' : ''); ?> <?php echo e((request()->is('admin/transferred-report')) ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-chart-bar"></i>
                        <p>
                            <?php echo e(__('Product')); ?>

                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview ">
                        <li class="nav-item">
                            <a href="<?php echo e(route('processing.report')); ?>" class="nav-link <?php echo e((request()->is('admin/processing-report')) ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-tools"></i>
                                <p><?php echo e(__('Processing')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('finished.report')); ?>" class="nav-link <?php echo e((request()->is('admin/finished-report')) ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-th-list"></i>
                                <p><?php echo e(__('Finished')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('transferred.report')); ?>" class="nav-link <?php echo e((request()->is('admin/transferred-report')) ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-random"></i>
                                <p><?php echo e(__('Transferred')); ?></p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-header text-bold"><?php echo e(__('ACCOUNT')); ?></li>
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.setup')); ?>" class="nav-link <?php echo e((request()->is('admin/setup')) ? 'active' : ''); ?> <?php echo e((request()->is('admin/general-settings')) ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-cogs"></i>
                        <p><?php echo e(__('Setup')); ?></p>
                    </a>
                </li>
                <li class="nav-item has-treeview <?php echo e((request()->is('admin/profile')) ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-user"></i>
                        <p>
                            <?php echo e(ucfirst(auth()->user()->name)); ?>

                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview ">
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.profile')); ?>" class="nav-link <?php echo e((request()->is('admin/profile')) ? 'active' : ''); ?>">
                                <i class="nav-icon fas fa-user-circle"></i>
                                <p><?php echo e(__('Profile')); ?></p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link admin-logout" href="<?php echo e(route('logout')); ?>" >
                                <i class="nav-icon fas fa-power-off"></i> <?php echo e(__('Logout')); ?>

                            </a>
                            <form id="sidebar-logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="no-display logout-form">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    </ul>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH C:\laragon\www\productify\resources\views/admin/components/side_nav.blade.php ENDPATH**/ ?>